package com.suncode.autoupdate.server.channel.dto;

import java.util.ArrayList;
import java.util.List;

import com.suncode.autoupdate.server.channel.UpdatePlan;
import com.suncode.autoupdate.server.patch.dto.PatchDto;

public class UpdatePlanDto
{
    private String newestVersion;

    private List<PatchDto> patches = new ArrayList<>();

    public UpdatePlanDto()
    {
    }

    public UpdatePlanDto( UpdatePlan plan )
    {
        if ( plan.getNewest() != null )
        {
            this.newestVersion = plan.getNewest().getVersion();
        }
        this.patches = PatchDto.from( plan.getPatches() );
    }

    public String getNewestVersion()
    {
        return newestVersion;
    }

    public void setNewestVersion( String newestVersion )
    {
        this.newestVersion = newestVersion;
    }

    public List<PatchDto> getPatches()
    {
        return patches;
    }

    public void setPatches( List<PatchDto> patches )
    {
        this.patches = patches;
    }
}
