package com.suncode.autoupdate.server.channel;

import java.util.ArrayList;
import java.util.List;

import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.Version;

public class UpdatePlan
{
    public static final UpdatePlan EMPTY = new UpdatePlan( null );

    private Version newest;

    private List<Patch> patches = new ArrayList<>();

    public UpdatePlan( Version newest )
    {
        this.newest = newest;
    }

    public boolean hasUpdates()
    {
        return !patches.isEmpty();
    }

    public void addPatch( Patch patch )
    {
        this.patches.add( patch );
    }

    public List<Patch> getPatches()
    {
        return patches;
    }

    public Version getNewest()
    {
        return newest;
    }
}
