import React, { useState } from "react";
import AsyncSelect from "react-select/async";

function toOptions(projects, query) {
  return projects
    .filter(project => project.type === "PLUGIN")
    .filter(project => matches(project.name, query))
    .map(project => {
      return {
        value: project.name,
        label: project.name
      };
    });
}

export default props => {
  const [projects, setProjects] = useState();

  return (
    <AsyncSelect
      cacheOptions
      defaultOptions
      loadOptions={query => {
        if (projects) {
          return Promise.resolve(toOptions(projects, query));
        }

        return fetch("/projects")
          .then(response => response.json())
          .then(projects => {
            setProjects(projects);
            return toOptions(projects, query);
          });
      }}
      {...props}
    />
  );
};

function matches(text, query) {
  return text.toLowerCase().search(query.toLowerCase()) > -1;
}
