import React from 'react';

export default class Health extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
        this.diskFree = this.diskFree.bind(this);
    }

    componentWillMount() {
        this.setState({loading: true});
        $.get("health").done(health => {
            this.setState({error: false, health: health});
        }).fail(() => {
            this.setState({error: true});
        }).always(() => {
            this.setState({loading: false});
        });
    }

    componentDidMount() {
        $('.easy-pie-chart').easyPieChart();
    }

    componentDidUpdate() {
        $('.easy-pie-chart').easyPieChart();
    }

    render() {
        if (!this.state.health) {
            return null;
        }

        var diskFree = this.diskFree();
        var freeMb = Math.round(this.state.health.diskSpace.free / 1000000);
        var totalMb = Math.round(this.state.health.diskSpace.total / 1000000);
        return (
            <div className="panel panel-default">
                <div className="panel-body status">
                  <div className="who padding-5">
                  <i className="fa fa-hdd-o fa-lg"></i>
                  <strong> HDD</strong>
                </div>
                <div id="diskspace-free">
                    <ul className="list-unstyled display-inline padding-5">
                      <li>
                        <p className="text-muted">
                          FREE:&nbsp;
                          <span className="txt-color-darken">
                            {freeMb} MB
                          </span>
                        </p>
                      </li>
                      <li>
                        <p className="text-muted">
                          TOTAL:&nbsp;
                          <span className="txt-color-darken">
                            {totalMb} MB
                          </span>
                        </p>
                      </li>
                    </ul>
                    <div className="easy-pie-chart" data-percent={diskFree}>
                        <span className="percent percent-sign">{diskFree}</span>
                    </div>
                </div>
                </div>
            </div>
        );
    }

    diskFree() {
        var space = this.state.health.diskSpace;
        return Math.round(((space.total - space.free) / space.total) * 100);
    }
}
