/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.store;

import com.google.common.base.Stopwatch;
import com.suncode.autoupdate.server.store.ProductsStorage;
import com.suncode.autoupdate.server.store.wooapi.WooApi;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
class Syncer {
    private static final Logger log = LoggerFactory.getLogger(Syncer.class);
    private final WooApi wooApi;
    private final ProductsStorage productsStorage;

    @Scheduled(cron="0 0 0 1/1 * ?")
    public void sync() {
        List products;
        log.info("Syncing products with suncode-store");
        Stopwatch timer = Stopwatch.createStarted();
        ArrayList total = new ArrayList();
        int page = 1;
        do {
            products = this.wooApi.v3().products(page++);
            total.addAll(products);
        } while (!products.isEmpty());
        this.productsStorage.save(total);
        log.info("Synced {} products in {}ms", (Object)total.size(), (Object)timer.elapsed(TimeUnit.MILLISECONDS));
    }

    @PostConstruct
    public void syncOnDeployment() {
        CompletableFuture.runAsync(() -> this.sync()).exceptionally(e -> {
            log.error("Error syncing products", e);
            return null;
        });
    }

    @ConstructorProperties(value={"wooApi", "productsStorage"})
    public Syncer(WooApi wooApi, ProductsStorage productsStorage) {
        this.wooApi = wooApi;
        this.productsStorage = productsStorage;
    }
}

