/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.store;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.autoupdate.server.client.api.ProjectId;
import com.suncode.autoupdate.server.store.ProductsStorage;
import com.suncode.autoupdate.server.store.wooapi.Product;
import java.beans.ConstructorProperties;
import java.sql.Timestamp;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import suncode.jooq.tables.StoreMapping;
import suncode.jooq.tables.StoreProducts;

@Component
@Transactional
class ProductsStorage {
    private static final Logger log = LoggerFactory.getLogger(ProductsStorage.class);
    private final DSLContext jooq;
    private final ObjectMapper mapper;
    private final Clock clock;

    @CacheEvict(cacheNames={"store.products.notMapped"}, allEntries=true)
    public void save(Collection<Product> products) {
        this.jooq.batch((Collection)products.stream().map(product -> this.jooq.insertInto((Table)StoreProducts.STORE_PRODUCTS).set((Field)StoreProducts.STORE_PRODUCTS.ID, (Object)product.getId().get()).set((Field)StoreProducts.STORE_PRODUCTS.PRODUCT, (Object)this.serialize(product)).set((Field)StoreProducts.STORE_PRODUCTS.CREATED, (Object)Timestamp.from(this.clock.instant())).onDuplicateKeyUpdate().set((Field)StoreProducts.STORE_PRODUCTS.PRODUCT, (Object)this.serialize(product)).set((Field)StoreProducts.STORE_PRODUCTS.UPDATED, (Object)Timestamp.from(this.clock.instant()))).collect(Collectors.toList())).execute();
    }

    @CacheEvict(cacheNames={"store.products.mapped", "store.products.notMapped"}, allEntries=true)
    public void addMapping(ProjectId projectId, Product.Id productPl, Product.Id productEn) {
        this.jooq.insertInto((Table)StoreMapping.STORE_MAPPING).set((Field)StoreMapping.STORE_MAPPING.PROJECT_ID, (Object)projectId.asString()).set((Field)StoreMapping.STORE_MAPPING.PRODUCT_EN, (Object)productEn.get()).set((Field)StoreMapping.STORE_MAPPING.PRODUCT_PL, (Object)productPl.get()).execute();
        log.info("Added mapping for projectId={} pl={} en={}", new Object[]{projectId, productPl, productEn});
    }

    @CacheEvict(cacheNames={"store.products.mapped", "store.products.notMapped"}, allEntries=true)
    public void deleteMapping(ProjectId projectId) {
        this.jooq.deleteFrom((Table)StoreMapping.STORE_MAPPING).where(StoreMapping.STORE_MAPPING.PROJECT_ID.eq((Object)projectId.asString())).execute();
        log.info("Deleted mapping for projectId={}", (Object)projectId);
    }

    @Cacheable(value={"store.products.mapped"})
    public List<Mapped> getMappedProducts() {
        StoreProducts pl = StoreProducts.STORE_PRODUCTS.as("product_pl");
        StoreProducts en = StoreProducts.STORE_PRODUCTS.as("product_en");
        return this.jooq.selectFrom((Table)StoreMapping.STORE_MAPPING.join((TableLike)pl).on(pl.ID.eq((Field)StoreMapping.STORE_MAPPING.PRODUCT_PL)).join((TableLike)en).on(en.ID.eq((Field)StoreMapping.STORE_MAPPING.PRODUCT_EN))).fetch().map(record -> new Mapped(ProjectId.projectId((String)((String)record.get((Field)StoreMapping.STORE_MAPPING.PROJECT_ID))), this.deserialize((String)record.get((Field)pl.PRODUCT, String.class)), this.deserialize((String)record.get((Field)en.PRODUCT, String.class))));
    }

    @Cacheable(value={"store.products.notMapped"})
    public List<Product> getNotMappedProducts() {
        return this.jooq.selectFrom((Table)StoreProducts.STORE_PRODUCTS).where(StoreProducts.STORE_PRODUCTS.ID.notIn((Select)DSL.select((SelectField)StoreMapping.STORE_MAPPING.PRODUCT_PL).from((TableLike)StoreMapping.STORE_MAPPING))).and(StoreProducts.STORE_PRODUCTS.ID.notIn((Select)DSL.select((SelectField)StoreMapping.STORE_MAPPING.PRODUCT_EN).from((TableLike)StoreMapping.STORE_MAPPING))).fetch(record -> this.deserialize(record.component2()));
    }

    private String serialize(Product product) {
        return this.mapper.writeValueAsString((Object)product);
    }

    private Product deserialize(String raw) {
        return (Product)this.mapper.readValue(raw, Product.class);
    }

    @ConstructorProperties(value={"jooq", "mapper", "clock"})
    public ProductsStorage(DSLContext jooq, ObjectMapper mapper, Clock clock) {
        this.jooq = jooq;
        this.mapper = mapper;
        this.clock = clock;
    }
}

