/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.project;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.patch.PatchFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import org.springframework.util.Assert;

@Entity
public class Project {
    private static final String NAME_REGEX = "[a-zA-Z][a-zA-Z0-9-_\\.]{0,50}";
    @Id
    private String name;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="project")
    private Set<Channel> channels = new HashSet();
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private PatchFormat patchFormat;
    @ManyToMany
    @JoinTable(name="project_permitted_clients", joinColumns={@JoinColumn(name="project_name")}, inverseJoinColumns={@JoinColumn(name="permitted_clients_id")})
    private Set<Client> permittedClients = new HashSet();

    Project() {
    }

    public Project(String name, PatchFormat format) {
        Assert.hasText((String)name);
        Assert.notNull((Object)format);
        Assert.isTrue((boolean)name.matches(NAME_REGEX), (String)"Name must match regex: [a-zA-Z][a-zA-Z0-9-_\\.]{0,50}");
        this.name = name.toLowerCase();
        this.patchFormat = format;
    }

    public String getName() {
        return this.name;
    }

    public PatchFormat getPatchFormat() {
        return this.patchFormat;
    }

    public Set<Channel> getChannels() {
        return this.channels;
    }

    public Set<Client> getPermittedClients() {
        return this.permittedClients;
    }

    public void permitClients(List<Client> clients) {
        this.permittedClients.clear();
        this.permittedClients.addAll(clients);
    }
}

