/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plugin.PluginPatchProperties;
import com.suncode.autoupdate.server.patch.PatchHandler;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.config.PluginDescriptor;
import com.suncode.plugin.framework.config.PluginDescriptorReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class PluginPatchFormat
implements PatchHandler {
    public boolean transforms(File source) {
        try {
            JarFile jarFile = new JarFile(source);
            jarFile.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Map<String, String> transform(PatchMeta patch, File source, OutputStream out) throws IOException {
        Version version = Version.parse((String)patch.getToVersion());
        try (FileInputStream in = new FileInputStream(source);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        ObjectMapper mapper = new ObjectMapper();
        PluginDescriptor descriptor = new PluginDescriptorReader().readDescriptor(source);
        Reference ref = Reference.of((String)descriptor.getKey(), (Version)version);
        ImmutableMap.Builder properties = ImmutableMap.builder();
        properties.put((Object)PluginPatchProperties.REQUIREMENTS, (Object)PluginPatchFormat.serializeRequirements((ObjectMapper)mapper, (PluginDescriptor)descriptor));
        descriptor.getDetails().getChangelog().ifPresent(uri -> properties.put((Object)PluginPatchProperties.CHANGELOG, (Object)uri.build(ref).toString()));
        descriptor.getDetails().getDocumentation().ifPresent(uri -> properties.put((Object)PluginPatchProperties.DOCUMENTATION, (Object)uri.build(ref).toString()));
        return properties.build();
    }

    private static String serializeRequirements(ObjectMapper mapper, PluginDescriptor descriptor) throws JsonProcessingException {
        return mapper.writeValueAsString(descriptor.getDetails().getRequirements().stream().map(requirement -> new PluginPatchProperties.PluginRequirement(requirement.getId(), requirement.getVersion().toString(), requirement.isMandatory())).collect(Collectors.toSet()));
    }

    public int compare(String version1, String version2) {
        return org.osgi.framework.Version.parseVersion((String)version1).compareTo(org.osgi.framework.Version.parseVersion((String)version2));
    }
}

