/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.channel.graph.AvailablePatches;
import com.suncode.autoupdate.server.channel.graph.Traversal;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.patch.PatchHandler;
import com.suncode.autoupdate.server.patch.Version;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.traverse.DepthFirstIterator;
import org.springframework.util.Assert;

public class ChannelGraph
extends DefaultDirectedGraph<Version, Patch> {
    private final UpdateChannel channel;

    public ChannelGraph(UpdateChannel channel) {
        super(Patch.class);
        Assert.notNull((Object)channel);
        this.channel = channel;
        this.init();
    }

    private void init() {
        this.addVertex((Object)Version.ANY);
        for (Patch patch : this.channel.getPatches()) {
            if (patch.isArchived()) continue;
            Version from = patch.getFromVersion();
            Version to = patch.getToVersion();
            this.addVertex((Object)from);
            this.addVertex((Object)to);
            this.addEdge((Object)from, (Object)to, (Object)patch);
        }
    }

    public Patch findNewest() {
        return this.findNewest(null);
    }

    public Patch findNewest(Version source) {
        return this.doFindNewest(this.doFindNewest(null, source), Version.ANY);
    }

    private Patch doFindNewest(Patch newest, Version source) {
        if (source != null && !this.containsVertex((Object)source)) {
            return null;
        }
        DepthFirstIterator iterator = new DepthFirstIterator((Graph)this, (Object)source);
        while (iterator.hasNext()) {
            Version v = (Version)iterator.next();
            if (!this.outgoingEdgesOf((Object)v).isEmpty()) continue;
            newest = this.newestPatch(newest, this.incomingEdgesOf((Object)v));
        }
        return newest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean willCreateCycle(Patch patch) {
        Version from = patch.getFromVersion();
        Version to = patch.getToVersion();
        try {
            this.addVertex((Object)from);
            this.addVertex((Object)to);
            this.addEdge((Object)from, (Object)to, (Object)patch);
            CycleDetector cycleDetector = new CycleDetector((DirectedGraph)this);
            boolean bl = cycleDetector.detectCycles();
            return bl;
        }
        finally {
            this.removeEdge((Object)patch);
            if (this.edgesOf((Object)from).isEmpty()) {
                this.removeVertex((Object)from);
            }
            if (this.edgesOf((Object)to).isEmpty()) {
                this.removeVertex((Object)to);
            }
        }
    }

    public AvailablePatches availablePatches(Version version) {
        ImmutableList fromVersion = this.containsVertex((Object)version) ? Traversal.traverseEdges((Graph)this, (Object)version) : ImmutableList.of();
        List fromAnyVersion = Traversal.traverseEdges((Graph)this, (Object)Version.ANY);
        PatchHandler handler = this.channel.getChannel().getPatchFormat().handler();
        Comparator<Version> versionComparator = Comparator.comparing(Version::getVersion, (arg_0, arg_1) -> ((PatchHandler)handler).compare(arg_0, arg_1));
        Comparator<Patch> patchComparator = Comparator.comparing(Patch::getToVersion, versionComparator);
        List<Patch> patchesFromNewest = Stream.of(fromVersion, fromAnyVersion).flatMap(Collection::stream).distinct().sorted(patchComparator.reversed()).collect(Collectors.toList());
        AvailablePatches.AvailablePatchesBuilder result = AvailablePatches.builder();
        patchesFromNewest.forEach(patch -> {
            if (version.equals((Object)Version.ANY) || versionComparator.compare(patch.getToVersion(), version) > 0) {
                result.upgrade(patch);
            } else if (!patch.getToVersion().equals((Object)version)) {
                result.downgrade(patch);
            }
        });
        return result.newest((Patch)Iterables.getFirst(patchesFromNewest, null)).build();
    }

    private Patch newestPatch(Patch current, Set<Patch> edges) {
        HashSet<Patch> merged = new HashSet<Patch>(edges);
        if (current != null) {
            merged.add(current);
        }
        return this.newestPatch(merged);
    }

    private Patch newestPatch(Set<Patch> edges) {
        Patch newest = null;
        for (Patch patch : edges) {
            newest = newest != null ? this.newestPatch(newest, patch) : patch;
        }
        return newest;
    }

    private Patch newestPatch(Patch patch1, Patch patch2) {
        PatchFormat patchFormat = this.channel.getChannel().getPatchFormat();
        int comparision = patchFormat.handler().compare(patch1.getToVersion().getVersion(), patch2.getToVersion().getVersion());
        if (comparision > 0) {
            return patch1;
        }
        if (comparision < 0) {
            return patch2;
        }
        if (patch1.getUploaded().after(patch2.getUploaded())) {
            return patch1;
        }
        return patch2;
    }

    public List<Patch> shortestPath(Version from, Version to) {
        if (!this.containsVertex((Object)from) || !this.containsVertex((Object)to)) {
            return Collections.emptyList();
        }
        DijkstraShortestPath shortestPath = new DijkstraShortestPath((Graph)this, (Object)from, (Object)to);
        return Optional.ofNullable(shortestPath.getPathEdgeList()).orElse(Collections.emptyList());
    }
}

