/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.ChannelRepository;
import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.event.EventRepository;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.storage.PatchStorage;
import com.suncode.autoupdate.server.project.Project;
import com.suncode.autoupdate.server.project.ProjectRepository;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class Channels {
    private static final Logger log = LoggerFactory.getLogger(Channels.class);
    private final ChannelRepository repository;
    private final ProjectRepository projectRepository;
    private final PatchStorage patchStorage;
    private final EventRepository eventRepository;

    @Transactional(readOnly=true)
    public UpdateChannel get(Channel.ChannelId id) {
        return this.channel(this.load(id));
    }

    @Transactional
    public UpdateChannel create(Channel.ChannelId id) {
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)id.getProjectName()));
        if (project == null) {
            throw new IllegalArgumentException("Project [" + id.getProjectName() + "] not exists");
        }
        Channel channel = new Channel(id.getName(), project);
        project.getChannels().add(channel);
        return this.channel(channel);
    }

    @Transactional
    public void remove(Channel.ChannelId id) {
        Channel channel = (Channel)this.repository.findOne((Serializable)id);
        for (Patch patch : channel.getPatches()) {
            this.eventRepository.deleteByPatch(patch.getId());
        }
        this.repository.delete((Serializable)id);
        try {
            this.patchStorage.purge(id);
        }
        catch (Exception e) {
            log.error("Could not drop patches for channel {}", (Object)id, (Object)e);
        }
    }

    private UpdateChannel channel(Channel channel) {
        return new UpdateChannel(channel, this.repository, this.patchStorage);
    }

    private Channel load(Channel.ChannelId id) {
        Channel channel = (Channel)this.repository.findOne((Serializable)id);
        if (channel != null) {
            return channel;
        }
        throw new IllegalStateException("Channel [" + id + "] not found");
    }

    @ConstructorProperties(value={"repository", "projectRepository", "patchStorage", "eventRepository"})
    @Autowired
    public Channels(ChannelRepository repository, ProjectRepository projectRepository, PatchStorage patchStorage, EventRepository eventRepository) {
        this.repository = repository;
        this.projectRepository = projectRepository;
        this.patchStorage = patchStorage;
        this.eventRepository = eventRepository;
    }
}

