import React, { useState, useEffect } from "react";
import ProductSelect from "./ProductSelect";
import ProjectSelect from "./ProjectSelect";

function Mapping(props) {
  const [productPl, setProductPL] = useState({});
  const [productEn, setProductEN] = useState({});
  const [plugin, setProject] = useState({});

  return (
    <div className="well" style={{ background: "white" }}>
      <h3>Dodaj wtyczkę</h3>
      <ProductSelect
        placeholder="Wybierz produkt PL"
        onChange={option => {
          setProductPL(option.value);
        }}
      />
      <ProductSelect
        placeholder="Wybierz produkt EN"
        onChange={option => {
          setProductEN(option.value);
        }}
      />
      <ProjectSelect
        placeholder="Wybierz wtyczkę"
        isClearable
        onChange={option => {
          setProject(option.value);
        }}
      />
      <div className="form-actions">
        <button
          className="btn btn-primary"
          onClick={() => {
            fetch("/store/mappings", {
              method: "POST",
              headers: {
                "Content-Type": "application/json"
              },
              body: JSON.stringify({
                plugin,
                productPl,
                productEn
              })
            }).then(response => {
              props.onMappingAdded();
            });
          }}
        >
          Dodaj
        </button>
      </div>
    </div>
  );
}

function Products(props) {
  return (
    <div>
      {props.products.map(product => {
        return (
          <Product
            key={product.projectId}
            mapping={product}
            onDeleted={() => {
              props.onMappingDeleted(product);
            }}
          />
        );
      })}
    </div>
  );
}

function Product({ mapping, onDeleted }) {
  const [lang, setLang] = useState("PL");

  const product = lang === "PL" ? mapping.productPl : mapping.productEn;

  return (
    <div className="well">
      <div>
        Język:
        <button
          onClick={() => {
            setLang(lang === "PL" ? "EN" : "PL");
          }}
        >
          {lang}
        </button>
      </div>
      <div>Wtyczka: {mapping.projectId}</div>
      <div>Nazwa: {product.name}</div>
      <div>
        Ikona: <img width="50px" height="50px" src={product.images[0].src} />
      </div>
      <div>Krótki opis: {product.short_description}</div>
      <div>Opis: {product.description}</div>
      <div>Cena: {product.price}</div>
      <div>Cena: {product.price_html}</div>
      <div>
        Link: <a href={product.permalink}>{product.permalink}</a>
      </div>

      <div className="form-actions">
        <button
          className="btn btn-primary"
          onClick={() => {
            fetch(`/store/mappings/${mapping.projectId}`, {
              method: "DELETE"
            }).then(response => {
              if (response.ok) {
                onDeleted();
              }
            });
          }}
        >
          Usuń
        </button>
      </div>
    </div>
  );
}

export default function Store() {
  const [products, setProducts] = useState([]);

  const fetchData = async function() {
    let response = await fetch("/store/mappings");
    let products = await response.json();
    setProducts(products);
  };

  useEffect(() => {
    fetchData();
  }, []);

  return (
    <div className="row">
      <div className="col-lg-3">
        <Mapping
          onMappingAdded={() => {
            fetchData();
          }}
        />
      </div>
      <div className="col-lg-9">
        <Products
          products={products}
          onMappingDeleted={mapping => {
            setProducts(products.filter(existing => existing !== mapping));
          }}
        />
      </div>
    </div>
  );
}
