import React from 'react';
import {withRouter} from 'react-router';

import Channels from './Channels.jsx';
import PermittedClients from './PermittedClients.jsx';

class Project extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
        this.handleDelete = this.handleDelete.bind(this);
    }
    componentDidMount() {
        $.get('projects/' + this.props.params.name, function(project) {
            this.setState({project: project});
        }.bind(this))
    }

    render() {
        if (!this.state.project) {
            return <h1 className="ajax-loading-animation">
                <i className="fa fa-cog fa-spin"></i>
            </h1>;
        }
        return (
            <div>
                <div className="row">
                    <div className="col-lg-12">
                        <form className="well" style={{backgroundColor: 'white'}}>
                            <PermittedClients project={this.state.project}/>
                            <div className="form-actions">
                            <div className="row">
                                <div className="col-lg-12">
                                    <a className="btn btn-danger" onClick={this.handleDelete}>Usuń projekt</a>
                                </div>
                            </div>
                          </div>
                        </form>
                    </div>
                </div>
                <Channels project={this.state.project}/>
            </div>
        );
    }

    handleDelete() {
        if (confirm('Projekt zostanie usunięty. Jesteś pewny?')) {
            $.ajax({
                url: 'projects/' + this.state.project.name,
                method: 'DELETE',
                success: function() {
                    this.props.router.push('/projects');
                }.bind(this)
            });
        }
    }
}
export default withRouter(Project);
