import React from 'react';
import Table from './../../components/Table.jsx';

export default class PermittedClients extends React.Component {
    constructor() {
        super();
    }
    componentWillMount() {
        this.data = this.props.project.permittedClients.map(client => {
            return {id: client.id, text: client.name};
        });
        this.selected = this.props.project.permittedClients.map(client => {
            return client.id;
        });
    }
    render() {
        return (

            <fieldset>
                <legend>
                    Ochrona dostępu
                </legend>
                <label>
                    Lista klientów którzy mogą pobierać aktualizację dla tego projektu.
                </label>
                <div className="form-group">
                    <select id="permittedClients" style={{
                        width: "100%"
                    }} className="select2" multiple="multiple" ref={elem => $(".select2").select2({
                        data: this.data,
                        ajax: {
                            url: '/clients',
                            delay: 250,
                            processResults: function(data, params) {
                                return {
                                    results: data.map(client => {
                                        return {id: client.id, text: client.name};
                                    })
                                };
                            }
                        }
                    }).on('change', this.onChange.bind(this)).val(this.selected).trigger('change')}></select>
                </div>
            </fieldset>
        )
    }

    onChange() {
        var clients = $('#permittedClients').val();
        if (!this.arrayEqual(this.selected, clients)) {
            $.ajax({
                url: 'projects/' + this.props.project.name + '/permittedClients',
                method: 'PUT',
                dataType: 'json',
                contentType: 'application/json',
                data: JSON.stringify(clients)
            });
        }
    }

    arrayEqual(a, b) {
        return $(a).not(b).get().length === 0 && $(b).not(a).get().length === 0;
    }
}
