import React from "react";
import ReactTable from "react-table";
import ReactJson from 'react-json-view'
import PatchProperties from './PatchProperties'
import PatchDetails from "./PatchDetails";

export default class PatchesTable extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: [],
            pages: null,
            loading: true,
            patch: null
        };
        this.channel = props.channel;
        this.fetchData = this.fetchData.bind(this);
    }

    fetchData() {
        this.setState({ loading: true });
        const {project, name} = this.channel;

        return fetch(`projects/${project}/channels/${name}/patches`, { credentials: 'same-origin' })
            .then(function(response) {
                return response.json()
            })
            .then((patches) => {
                this.setState({
                    loading: false,
                    data: patches
                });
            });
    }


    render() {
        const { data, loading, patch } = this.state;
        return <div className="well">
            <PatchDetails
                patch={patch}
                onClose={() => this.setState({patch: null})}
            />
            <ReactTable ref="clientsTable"
                        columns={[
                            {
                                Header: "Uploaded",
                                className: "text-center",
                                accessor: "uploaded",
                                width: 150,
                                Cell: (row) => new Date(row.value).toLocaleString()
                            },
                            {
                                Header: "Od wersji",
                                className: "text-center",
                                accessor: "fromVersion",
                                width: 100,
                                filterable: true
                            },
                            {
                                Header: "Do wersji",
                                className: "text-center",
                                accessor: "toVersion",
                                width: 100,
                                filterable: true
                            },
                            {
                                Header: "Metadata",
                                accessor: "properties",
                                Cell: (row) => <PatchProperties patch={row.original}/>
                            },
                            {
                                Header: "Aktywny",
                                className: "text-center",
                                accessor: "archived",
                                width: 80,
                                filterable: false,
                                Cell: (row) => row.value ? "Nie" : "Tak"
                            },
                            {
                                width: 40,
                                Cell: (row) => {
                                    return <button
                                        className={"btn btn-default btn-xs txt-color-blue"}
                                        onClick={() => {this.setState({patch: row.original})}}
                                    >
                                        <i className={"fa fa-search"}/>
                                    </button>
                                }
                            }
                        ]}
                        data={data}
                        loading={loading}
                        onFetchData={this.fetchData}
                        defaultSorted={[{
                            id: 'uploaded',
                            desc: true
                        }]}
                        minRows={0}
                        defaultPageSize={10}
                        className="-highlight"
                        getTrProps={(state, rowInfo) => {
                            return rowInfo?.original.archived && ({
                                style: {
                                    backgroundColor: "rgb(223 223 223)",
                                    opacity: 0.7
                                }
                            }) || {}
                        }}
            />
        </div>
    }
}
