import React from "react";

export default class PatchesDownload extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      from: "",
      to: "",
      generating: false
    };
    this.generatePatch = this.generatePatch.bind(this);
  }

  generatePatch() {
    if (this.state.from && this.state.to) {
      this.setState({ generating: true });
      fetch(
        `projects/${this.props.channel.project}/channels/${this.props.channel.name}/merge?from=${this.state.from}&to=${this.state.to}`
      )
        .then(response => {
          if (response.ok) {
            return response.json();
          }
          throw response;
        })
        .then(uri => {
          const link = document.createElement("a");
          link.href = uri;
          document.body.appendChild(link);
          link.click();
          link.parentNode.removeChild(link);
        })
        .catch(response => {
            response.text().then(text => {
                alert(text);
            })
        })
        .finally(() => {
          this.setState({ generating: false });
        });
    }
  }

  render() {
    return (
      <div className="well">
        <div className="row form-row">
          <div className="col-lg-3">
            <div className="input-group">
              <span className="input-group-addon">
                <strong>#</strong>
              </span>
              <input
                value={this.state.from}
                onChange={e => this.setState({ from: e.target.value })}
                className="form-control"
                name="name"
                type="text"
                placeholder="Od wersji"
              />
            </div>
          </div>
          <div className="col-lg-3">
            <div className="input-group">
              <span className="input-group-addon">
                <strong>#</strong>
              </span>
              <input
                value={this.state.to}
                onChange={e => this.setState({ to: e.target.value })}
                className="form-control"
                name="name"
                type="text"
                placeholder="Od wersji"
              />
            </div>
          </div>
          <div className="col-lg-2">
            <button
              onClick={this.generatePatch}
              disabled={this.state.generating}
              type="submit"
              className="btn btn-primary form-control"
            >
              <i className="fa fa-download"></i>
              <strong>&nbsp; Wygeneruj</strong>
            </button>
          </div>
        </div>
      </div>
    );
  }
}
