import React from 'react';

export default class Database extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    componentWillMount() {
        this.setState({loading: true});
        $.get("metrics").done(metrics=> {
            this.setState({error: false, metrics: metrics});
        }).fail(() => {
            this.setState({error: true});
        }).always(() => {
            this.setState({loading: false});
        });
    }

    componentDidMount() {
        $('.easy-pie-chart').easyPieChart();
    }

    componentDidUpdate() {
        $('.easy-pie-chart').easyPieChart();
    }

    render() {
        if (!this.state.metrics) {
            return null;
        }

        var activeConnections = this.state.metrics["datasource.primary.active"];
        var usedPercent = this.state.metrics["datasource.primary.usage"] * 100;

        return (
            <div className="panel panel-default">
                <div className="panel-body status">
                  <div className="who padding-5">
	                  <i className="fa fa-hdd-o fa-lg"></i>
	                  <strong> DATABASE POOL</strong>
	                </div>
	                <div id="heap">
	                    <ul className="list-unstyled display-inline padding-5">
	                      <li>
	                        <p className="text-muted">
	                          ACTIVE:&nbsp;
	                          <span className="txt-color-darken">
	                            {activeConnections}
	                          </span>
	                        </p>
	                       </li>
	                    </ul>
	                    <div className="easy-pie-chart" data-percent={usedPercent}>
	                        <span className="percent percent-sign">{usedPercent}</span>
	                    </div>
	                </div>
                </div>
            </div>
        );
    }
}
