import React from 'react';
import Table from './../../components/Table.jsx';
import Select2 from './../../components/Select2.jsx';
import DatePicker from './../../components/DatePicker.jsx';

export default class Events extends React.Component {

    constructor(props) {
        super(props);
        this.state = {
            filter: {
                channel: "",
                project: "",
                client: props.client.id,
                patchType: [],
                dateFrom: "",
                dateTo: ""
            }
        };
        this.requestParams = this.requestParams.bind(this);
        this.responseData = this.responseData.bind(this);
    }

    componentDidMount() {
        this.table = $("#events").DataTable({
            "paging": true,
            "info": false,
            "searching": false,
            "serverSide": true,
            "processing": true,
            "order": [
                [1, 'desc']
            ],
            "columns": [
                {
                    title: 'Zdarzenie',
                    data: 'type'
                }, {
                    title: 'Data',
                    data: 'date'
                }, {
                    title: 'Klient',
                    data: 'client'
                }, {
                    title: 'Środowisko',
                    data: 'clientEnv'
                }, {
                    title: 'Projekt',
                    data: 'project'
                }, {
                    title: 'Kanał',
                    data: 'channel'
                }, {
                    title: 'Wersja od',
                    data: 'fromVersion'
                }, {
                    title: 'Wersja do',
                    data: 'toVersion'
                }, {
                    title: 'PlusWorkflow',
                    data: 'plusworkflowVersion',
                    sortable: false
                }
            ],
            "ajax": {
                url: 'events',
                data: this.requestParams,
                dataSrc: this.responseData
            }
        });
    }

    requestParams(data, settings) {
        var sort = data.order[0];
        var sortOverride = {
          "project": "patch.channel.project.name",
          "channel": "patch.channel.id.name",
          "fromVersion": "patch.fromVersion.version",
          "toVersion": "patch.toVersion.version"
        };
        var sortColumn = data.columns[sort.column].data;
        if(sortOverride.hasOwnProperty(sortColumn)){
          sortColumn = sortOverride[sortColumn];
        }
        return {
            filter: JSON.stringify(this.state.filter),
            size: data.length,
            page: data.start / data.length,
            sort: sortColumn + ',' + sort.dir
        };
    }

    responseData(data) {
        data.recordsTotal = data.totalElements;
        data.recordsFiltered = data.totalElements;
        return data.content.map(row => {
            return $.extend(row, {
                date: this.formatDate(new Date(row.date))
            });
        });
    }

    render() {
        return (
            <div className="well well-light dataTables_wrapper">
                <table id="events" className="table table-bordered table-hover"></table>
            </div>
        )
    }

    formatDate(d) {
        return ("00" + (d.getMonth() + 1)).slice(-2) + "-" + ("00" + d.getDate()).slice(-2) + "-" + d.getFullYear() + " " + ("00" + d.getHours()).slice(-2) + ":" + ("00" + d.getMinutes()).slice(-2) + ":" + ("00" + d.getSeconds()).slice(-2)
    }
}
