import React from 'react';
import ClientsTable from './ClientsTable.jsx';
import NewClientForm from './NewClientForm.jsx';

export default class Clients extends React.Component {
    constructor() {
      super();
      this.reload = this.reload.bind(this);
    }

    reload() {
        if(this.table) {
          this.table.fetchData();
        }
    }

    render() {
        return (
          <div>
            <div className="row">
              <div className="col-lg-8">
                <ClientsTable ref={function(ref){this.table = ref;}.bind(this)}/>
              </div>
              <div className="col-lg-4">
                <NewClientForm onNewClient={this.reload}/>
              </div>
            </div>
          </div>
        )
    }
}
