import React from "react";
import { Link, IndexLink } from "react-router";

import "whatwg-fetch";
import Promise from "promise-polyfill";

export default class Index extends React.Component {
  render() {
    return (
      <div>
        <aside id="left-panel">
          <nav>
            <ul>
              <li>
                <IndexLink activeClassName="active" to="/dashboard">
                  <i className="fa fa-lg fa-fw fa-home"></i>
                  <span className="menu-item-parent">Dashboard</span>
                </IndexLink>
              </li>
              <li>
                <IndexLink activeClassName="active" to="/clients">
                  <i className="fa fa-lg fa-fw fa-group"></i>
                  <span className="menu-item-parent">Klienci</span>
                </IndexLink>
              </li>
              <li>
                <IndexLink activeClassName="active" to="/projects">
                  <i className="fa fa-lg fa-fw fa-database"></i>
                  <span className="menu-item-parent">Projekty</span>
                </IndexLink>
              </li>
              <li>
                <IndexLink activeClassName="active" to="/events">
                  <i className="fa fa-lg fa-fw fa-bullseye"></i>
                  <span className="menu-item-parent">Dziennik zdarzeń</span>
                </IndexLink>
              </li>
              <li>
                <IndexLink activeClassName="active" to="/store">
                  <i className="fa fa-lg fa-fw fa-shopping-cart"></i>
                  <span className="menu-item-parent">Store</span>
                </IndexLink>
              </li>
            </ul>
          </nav>
        </aside>
        <div id="main">
          <div id="content">{this.props.children}</div>
        </div>
      </div>
    );
  }
}
