package com.suncode.autoupdate.server.store.wooapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Value;

import java.math.BigDecimal;
import java.net.URI;
import java.time.LocalDateTime;
import java.util.List;

@Value
@JsonNaming(SnakeCaseStrategy.class)
public class Product {
    Id id;
    String name;
    Slug slug;
    URI permalink;
    LocalDateTime dateCreated;
    LocalDateTime dateCreatedGmt;
    LocalDateTime dateModified;
    LocalDateTime dateModifiedGmt;
    Visiblity catalogVisibility;
    String description;
    String shortDescription;
    BigDecimal price;
    String priceHtml;
    List<Tag> categories;
    List<Tag> tags;
    List<Image> images;

    @Value
    public static class Id {
        Long id;

        @JsonValue
        public Long get() {
            return id;
        }

        @JsonCreator
        public static Product.Id productId(Long id) {
            return new Product.Id(id);
        }
    }
}
