package com.suncode.autoupdate.server.store;

import com.google.common.base.Stopwatch;
import com.suncode.autoupdate.server.store.wooapi.Product;
import com.suncode.autoupdate.server.store.wooapi.WooApi;
import lombok.RequiredArgsConstructor;
import lombok.experimental.FieldDefaults;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

import static java.util.concurrent.CompletableFuture.runAsync;
import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static lombok.AccessLevel.PRIVATE;

@Slf4j
@Component
@RequiredArgsConstructor
@FieldDefaults(level = PRIVATE, makeFinal = true)
class Syncer {
    WooApi wooApi;
    ProductsStorage productsStorage;

    @Scheduled(cron = "0 0 0 1/1 * ?")
    public void sync() {
        log.info("Syncing products with suncode-store");

        Stopwatch timer = Stopwatch.createStarted();

        List<Product> total = new ArrayList<>();
        List<Product> products;

        int page = 1;
        do {
            products = wooApi.v3().products(page++);
            total.addAll(products);
        }
        while (!products.isEmpty());

        productsStorage.save(total);
        log.info("Synced {} products in {}ms", total.size(), timer.elapsed(MILLISECONDS));
    }

    @PostConstruct
    public void syncOnDeployment() {
        runAsync(this::sync)
                .exceptionally(e -> {
                    log.error("Error syncing products", e);
                    return null;
                });
    }
}
