package com.suncode.autoupdate.server.patch.types;

import static java.lang.Integer.parseInt;
import static java.util.Collections.emptyMap;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

import com.suncode.autoupdate.server.patch.PatchHandler;
import org.apache.commons.io.FileUtils;

import com.suncode.autoupdate.patch.PatchMeta;
import com.suncode.autoupdate.patch.plusworkflow.archive.Archive;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.patch.plusworkflow.pluspatch.PlusPatch3Transformer;

import lombok.SneakyThrows;

/**
 * Binary patch.
 * 
 * @author Cezary Kozar 18 maj 2016
 */
public class PlusWorkflowPatchFormat
    implements PatchHandler
{
    @Override
    public boolean transforms( File source )
    {
        return PlusPatch3Transformer.isPlusPatch3( source );
    }

    @Override
    public Map<String, String> transform(PatchMeta patch, File source, OutputStream out )
        throws IOException
    {
        try (Archive archive = archive( patch, source ))
        {
            // TODO: weryfikacja czy patch jest poprawny
            FileUtils.copyFile( archive.getFile(), out );
        }
        return emptyMap();
    }

    private Archive archive( PatchMeta patch, File rawPatch )
        throws IOException
    {
        PlusPatch3Transformer plusPatch = new PlusPatch3Transformer( patch, rawPatch );
        return plusPatch.transform();
    }

    @Override
    public int compare( String version1, String version2 )
    {
        return Integer.compare( parseInt( version1 ), parseInt( version2 ) );
    }

    @SneakyThrows
    public Index readIndex( File patchArchive )
    {
        try (Archive archive = new Archive( patchArchive ))
        {
            archive.open();
            return archive.getIndex();
        }
    }
}
