package com.suncode.autoupdate.server.patch.storage;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.springframework.core.io.Resource;

import com.suncode.autoupdate.server.channel.Channel.ChannelId;
import com.suncode.autoupdate.server.patch.Patch;

/**
 * Patch storage abstraction. Responsible for storing and reading patch archives.
 * 
 * @author Cezary Kozar 14 maj 2016
 */
public interface PatchStorage
{
    interface StorageOutput
    {
        void store( OutputStream out )
            throws IOException;
    }

    void store( Patch patch, File patchFile )
        throws IOException;

    void store( Patch patch, InputStream patchInput )
        throws IOException;

    void store( Patch patch, StorageOutput output )
        throws IOException;

    Resource read( Patch patch );

    void purge( ChannelId channel )
        throws IOException;
}
