package com.suncode.autoupdate.server.patch;

import javax.persistence.Embeddable;

import org.springframework.util.Assert;

@Embeddable
public class Version
{
    public static final Version EMPTY = new Version( "" );
    public static final Version ANY = new Version( "*" );

    private String version;

    Version()
    {
    }

    public Version( String version )
    {
        Assert.notNull( version );
        this.version = version;
    }

    public String getVersion()
    {
        return version;
    }

    @Override
    public int hashCode()
    {
        return version.hashCode();
    }

    @Override
    public boolean equals( Object obj )
    {
        if ( this == obj )
        {
            return true;
        }
        if ( obj == null )
        {
            return false;
        }
        if ( obj.getClass().equals( Version.class ) )
        {
            return version.equals( ( (Version) obj ).version );
        }
        return false;
    }
    
    @Override
    public String toString()
    {
        return version;
    }
}
