package com.suncode.autoupdate.server.patch;

import com.suncode.autoupdate.server.patch.types.PluginPatchFormat;
import com.suncode.autoupdate.server.patch.types.PlusWorkflowPatchFormat;

/**
 * Supported patch formats.
 * 
 * @author Cezary Kozar 26 kwi 2016
 */
public enum PatchFormat
{
    /**
     * PlusWorkflow patch. Supports transformation from PlusPatch3 notation.
     */
    PLUSWORKFLOW
    {
        @Override
        public PatchHandler handler()
        {
            return new PlusWorkflowPatchFormat();
        }
    },
    
    /**
     * Plugin patch. One jar project.
     */
    PLUGIN
    {
        @Override
        public PatchHandler handler()
        {
            return new PluginPatchFormat();
        }
    };
    
    public abstract PatchHandler handler();
}
