package com.suncode.autoupdate.server.event;

import java.util.Calendar;
import java.util.Date;

public class EventsFilter
{
    private EventType[] patchType;

    private Date dateFrom;

    private Date dateTo;

    private String client;

    private String project;

    private String channel;

    public EventType[] getPatchType()
    {
        return patchType;
    }

    public void setPatchType( EventType[] patchType )
    {
        this.patchType = patchType;
    }

    public Date getDateFrom()
    {
        return dateFrom;
    }

    public void setDateFrom( Date dateFrom )
    {
        if ( dateFrom != null )
        {
            Calendar cal = Calendar.getInstance();
            cal.setTime( dateFrom );
            cal.set( Calendar.HOUR_OF_DAY, 0 );
            cal.set( Calendar.MINUTE, 0 );
            cal.set( Calendar.SECOND, 0 );
            dateFrom = cal.getTime();
        }
        this.dateFrom = dateFrom;
    }

    public Date getDateTo()
    {
        return dateTo;
    }

    public void setDateTo( Date dateTo )
    {
        if ( dateTo != null )
        {
            Calendar cal = Calendar.getInstance();
            cal.setTime( dateTo );
            cal.set( Calendar.HOUR_OF_DAY, 23 );
            cal.set( Calendar.MINUTE, 59 );
            cal.set( Calendar.SECOND, 59 );
            dateTo = cal.getTime();
        }
        this.dateTo = dateTo;
    }

    public String getClient()
    {
        return client;
    }

    public void setClient( String client )
    {
        this.client = client;
    }

    public String getProject()
    {
        return project;
    }

    public void setProject( String project )
    {
        this.project = project;
    }

    public String getChannel()
    {
        return channel;
    }

    public void setChannel( String channel )
    {
        this.channel = channel;
    }
}