package com.suncode.autoupdate.server.event;

import javax.transaction.Transactional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchRepository;
import com.suncode.autoupdate.server.security.ClientAuthenticationToken;

@Service
@Transactional
public class Events
{
    @Autowired
    private EventRepository eventRepository;

    @Autowired
    private PatchRepository patchRepository;

    public void patchDownload( Patch patch, String clientEnv )
    {
        Event event = new Event( EventType.PATCH_DOWNLOAD, currentClient(), clientEnv, patch );
        eventRepository.save( event );
    }

    public void patchUpload( Patch patch )
    {
        Event event = new Event( EventType.PATCH_UPLOAD, currentClient(), null, patch );
        eventRepository.save( event );
    }

    public void updateSuccess( String patchId, String clientEnv, String data )
    {
        event( EventType.UPDATE_SUCCESS, patchId, clientEnv, data );
    }

    public void updateError( String patchId, String clientEnv, String data )
    {
        event( EventType.UPDATE_ERROR, patchId, clientEnv, data );
    }

    public void rollbackSuccess( String patchId, String clientEnv, String data )
    {
        event( EventType.ROLLBACK_SUCCESS, patchId, clientEnv, data );
    }

    public void rollbackError( String patchId, String clientEnv, String data )
    {
        event( EventType.ROLLBACK_ERROR, patchId, clientEnv, data );
    }
    
    private void event( EventType eventType, String patchId, String clientEnv, String data )
    {
        Patch patch = patchRepository.findOne( patchId );
        Event event = new Event( eventType, currentClient(), clientEnv, patch );
        event.setData( data );

        eventRepository.save( event );
    }

    private String currentClient()
    {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if ( authentication instanceof ClientAuthenticationToken )
        {
            return (String) authentication.getPrincipal();
        }
        return null;
    }
}