package com.suncode.autoupdate.server.event;

import java.util.Date;

import com.suncode.autoupdate.patch.plusworkflow.Props;
import com.suncode.autoupdate.server.patch.Patch;

import static com.suncode.autoupdate.patch.plusworkflow.Props.PLUSWORKFLOW_VERSION;

public class EventDto
{
    private Long id;

    private EventType type;

    private Date date;

    private String client;

    private String clientEnv;

    private String data;

    private String project;

    private String channel;

    private String patchId;

    private String fromVersion;

    private String toVersion;

    private String plusworkflowVersion;

    private String cufVersion;

    public EventDto()
    {
    }

    public EventDto( Event event )
    {
        this.id = event.getId();
        this.type = event.getType();
        this.date = event.getDate();
        this.client = event.getClient();
        this.clientEnv = event.getClientEnv();
        this.data = event.getData();
        Patch patch = event.getPatch();
        if ( patch != null )
        {
            this.patchId = patch.getId();
            this.project = patch.getChannel().getId().getProjectName();
            this.channel = patch.getChannel().getId().getName();
            this.fromVersion = patch.getFromVersion().getVersion();
            this.toVersion = patch.getToVersion().getVersion();
            this.plusworkflowVersion = patch.getProperty(PLUSWORKFLOW_VERSION.property());
            this.cufVersion = patch.getProperty( "cuf-version" );
        }
    }

    public Long getId()
    {
        return id;
    }

    public void setId( Long id )
    {
        this.id = id;
    }

    public EventType getType()
    {
        return type;
    }

    public void setType( EventType type )
    {
        this.type = type;
    }

    public Date getDate()
    {
        return date;
    }

    public void setDate( Date date )
    {
        this.date = date;
    }

    public String getClient()
    {
        return client;
    }

    public void setClient( String client )
    {
        this.client = client;
    }

    public String getClientEnv()
    {
        return clientEnv;
    }

    public void setClientEnv( String clientEnv )
    {
        this.clientEnv = clientEnv;
    }

    public String getData()
    {
        return data;
    }

    public void setData( String data )
    {
        this.data = data;
    }

    public String getProject()
    {
        return project;
    }

    public void setProject( String project )
    {
        this.project = project;
    }

    public String getChannel()
    {
        return channel;
    }

    public void setChannel( String channel )
    {
        this.channel = channel;
    }

    public String getPatchId()
    {
        return patchId;
    }

    public void setPatchId( String patchId )
    {
        this.patchId = patchId;
    }

    public String getFromVersion()
    {
        return fromVersion;
    }

    public void setFromVersion( String fromVersion )
    {
        this.fromVersion = fromVersion;
    }

    public String getToVersion()
    {
        return toVersion;
    }

    public void setToVersion( String toVersion )
    {
        this.toVersion = toVersion;
    }

    public String getPlusworkflowVersion()
    {
        return plusworkflowVersion;
    }

    public void setPlusworkflowVersion( String plusworkflowVersion )
    {
        this.plusworkflowVersion = plusworkflowVersion;
    }

    public String getCufVersion()
    {
        return cufVersion;
    }

    public void setCufVersion( String cufVersion )
    {
        this.cufVersion = cufVersion;
    }
}
