package com.suncode.autoupdate.server.channel.dto;

import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.dto.PatchDto;

public class UpdateChannelDto
{
    private String name;

    private String project;

    private PatchDto newestPatch;

    private int patchesCount;

    public UpdateChannelDto()
    {
    }

    public UpdateChannelDto( UpdateChannel channel )
    {
        this.name = channel.id().getName();
        this.project = channel.id().getProjectName();
        this.patchesCount = channel.getPatches().size();
        this.newestPatch = channel.newestPatch()
                .map(PatchDto::new)
                .orElse(null);
    }

    public String getName()
    {
        return name;
    }

    public String getProject()
    {
        return project;
    }

    public PatchDto getNewestPatch()
    {
        return newestPatch;
    }

    public int getPatchesCount()
    {
        return patchesCount;
    }
}
