package com.suncode.autoupdate.server.channel.dto;

import java.util.ArrayList;
import java.util.List;

import com.suncode.autoupdate.server.channel.graph.ChannelGraph;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.Version;
import com.suncode.autoupdate.server.patch.dto.PatchDto;

public class ChannelGraphDto
{
    private List<VersionNode> nodes = new ArrayList<>();

    private List<PatchEdge> edges = new ArrayList<>();;

    public ChannelGraphDto()
    {
    }

    public ChannelGraphDto( ChannelGraph graph )
    {
        for ( Version version : graph.vertexSet() )
        {
            this.nodes.add( new VersionNode( version ) );
        }

        for ( Patch patch : graph.edgeSet() )
        {
            this.edges.add( new PatchEdge( patch ) );
        }
    }

    public List<VersionNode> getNodes()
    {
        return nodes;
    }

    public List<PatchEdge> getEdges()
    {
        return edges;
    }

    public static class VersionNode
    {
        private String id;

        public VersionNode( Version version )
        {
            this.id = version.getVersion();
        }

        public String getId()
        {
            return id;
        }

        public String getLabel()
        {
            return id;
        }
    }

    public static class PatchEdge
    {
        private PatchDto patch;

        private String from;

        private String to;

        public PatchEdge( Patch patch )
        {
            this.patch = new PatchDto( patch );
            this.from = patch.getFromVersion().getVersion();
            this.to = patch.getToVersion().getVersion();
        }

        public String getFrom()
        {
            return from;
        }

        public String getTo()
        {
            return to;
        }

        public PatchDto getPatch()
        {
            return patch;
        }

        public void setPatch( PatchDto patch )
        {
            this.patch = patch;
        }
    }
}
