import React from 'react';
import PatchProperties from './PatchProperties'

export default class PatchDetails extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
        this.downloadUrl = this.downloadUrl.bind(this);
        this.archivePatch = this.archivePatch.bind(this);
    }

    componentDidMount() {
        this.showModal();
    }
    componentDidUpdate() {
        this.showModal();
    }

    showModal() {
        if (this.props.patch) {
            if (!this.state.patchDiff) {
                $.ajax({
                    url: "patches/" + this.props.patch.id + '/diff',
                    method: 'GET',
                    success: function(data) {
                        this.setState({
                            patchDiff: data || {}
                        });
                    }.bind(this)
                });
            }
            $(this.refs.modal).modal().on('hidden.bs.modal', () => {
                this.props.onClose();
                this.setState({patchDiff: null});
            });
        }
    }

    archivePatch() {
        console.log("Archiving...");

        $.ajax({
            url: "patches/" + this.props.patch.id,
            method: 'DELETE',
            success: () => {
                $(this.refs.modal).modal('hide');
            }
        });
    }

    render() {
        if (!this.props.patch) {
            return null;
        }
        return (
            <div ref="modal" className="modal fade" style={{
                display: 'none'
            }}>
                <div className="modal-dialog" style={{
                    width: '800px'
                }}>
                    <div className="modal-content">
                        <div className="modal-header">
                            <h4 className="modal-title">Szczegóły</h4>
                        </div>
                        <div className="modal-body">
                            <div>
                                <p className="text-muted">ID:&nbsp;
                                    <span className="txt-color-darken">{this.props.patch.id}</span>
                                </p>
                                <p className="text-muted">Wersja od:&nbsp;
                                    <span className="txt-color-darken">{this.props.patch.fromVersion}</span>
                                </p>
                                <p className="text-muted">Wersja do:&nbsp;
                                    <span className="txt-color-darken">{this.props.patch.toVersion}</span>
                                </p>
                                <div className="text-muted">
                                    <i className="fa fa-table"></i>
                                    &nbsp;&nbsp;Metadata:&nbsp;
                                    <PatchProperties patch={this.props.patch} collapsed={false}/>
                                </div>
                                <div className="data-container" style={{
                                    overflow: 'scroll',
                                    maxHeight: '300px'
                                }}>
                                    {this.renderChanges()}
                                </div>
                            </div>
                        </div>
                        <div className="modal-footer">
                            <a href={this.downloadUrl()} className="btn btn-sm btn-primary pull-left m-t-n-xs">
                                <i className="fa fa-download"></i>
                                <strong>:&nbsp;Download</strong>
                            </a>

                            <button type="button" className="btn btn-danger" onClick={() => { if (window.confirm('Czy na pewno chcesz zarchiwizować tą wersję?')) this.archivePatch() } } >
                                Archiwizuj
                            </button>
                            <button type="button" className="btn btn-default" data-dismiss="modal">
                                Zamknij
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        );
    }

    renderChanges() {
        if (!this.state.patchDiff) {
            return <h1 className="ajax-loading-animation">
                <i className="fa fa-cog fa-spin"></i>
            </h1>;
        }
        return (
            <ul>
                {Object.entries(this.state.patchDiff).map(prop => {
                    return prop[1].map(path => {
                        return <li>{prop[0][0].toUpperCase()}: {path}</li>;
                    });
                })}
            </ul>
        );
    }

    downloadUrl() {
        return "/patches/download/" + this.props.patch.id;
    }
}
