import React from 'react';

export default class DatePicker extends React.Component {

    componentDidMount() {
      var config = $.extend({}, {
        dateFormat: "yy-mm-dd"
      }, this.props);

      $(this.refs.input).datepicker(config)
        .change((e) => {
          this.handleChange(e);
        });
    }

    handleChange(e) {
      if(this.props.onChange){
        this.props.onChange(e);
      }
    }

    render() {
        return (
          <div className="input-group">
                <input onChange={this.handleChange} className="form-control" ref="input" type="text" {...this.props} ></input>
              <span className="input-group-addon">
                  <i className="fa fa-calendar"></i>
              </span>
          </div>


        )
    }
}
