/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.patch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.suncode.autoupdate.patch.plusworkflow.archive.Index;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.Channels;
import com.suncode.autoupdate.server.client.Client;
import com.suncode.autoupdate.server.event.Events;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchController;
import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.patch.PatchRepository;
import com.suncode.autoupdate.server.patch.Version;
import com.suncode.autoupdate.server.patch.storage.PatchStorage;
import com.suncode.autoupdate.server.patch.types.PlusWorkflowPatchFormat;
import com.suncode.autoupdate.server.project.Project;
import com.suncode.autoupdate.server.security.ClientAuth;
import com.suncode.autoupdate.server.security.HasAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/patches"})
public class PatchController {
    private static final Logger log = LoggerFactory.getLogger(PatchController.class);
    private final Events events;
    private final Channels channels;
    private final PatchStorage patchStorage;
    private final PatchRepository patchRepository;
    private ObjectMapper objectMapper = new ObjectMapper();

    @Autowired
    public PatchController(Events events, Channels channels, PatchStorage patchStorage, PatchRepository patchRepository) {
        this.events = events;
        this.channels = channels;
        this.patchStorage = patchStorage;
        this.patchRepository = patchRepository;
    }

    @RequestMapping(value={"download/{uuid}"}, method={RequestMethod.GET})
    public void download(@PathVariable String uuid, @RequestParam(required=false) String clientEnv, SecurityContextHolderAwareRequestWrapper request, HttpServletResponse response) throws IOException {
        Patch patch = (Patch)this.patchRepository.findOne((Serializable)((Object)uuid));
        if (patch == null) {
            throw new IllegalArgumentException("No patch with given id");
        }
        if (patch.isArchived()) {
            throw new IllegalArgumentException("Patch is archived");
        }
        if (!HasAccess.hasAccessToProject((Project)patch.getChannel().getProject(), (SecurityContextHolderAwareRequestWrapper)request)) {
            throw new AccessDeniedException("Client not permitted to download a patch");
        }
        log.info("Patch download requested: {}", (Object)patch.getId());
        Resource patchResource = this.patchStorage.read(patch);
        this.events.patchDownload(patch, clientEnv);
        response.setHeader("Content-Type", "application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + uuid + "\"");
        try (InputStream in = patchResource.getInputStream();
             OutputStream out = this.patchOutputStream(patch, response);){
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
    }

    private OutputStream patchOutputStream(Patch patch, HttpServletResponse response) {
        ServletOutputStream out = response.getOutputStream();
        Client client = ClientAuth.getAuthenticatedClient();
        boolean compress = client != null ? client.compressPatches() : false;
        return compress ? new GZIPOutputStream((OutputStream)out) : out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/{project:.+}/{channel}/upload"}, method={RequestMethod.POST})
    public void upload(@PathVariable String project, @PathVariable String channel, @RequestParam String fromVersion, @RequestParam String toVersion, @RequestParam(required=false) String props, @RequestParam MultipartFile patch) throws IOException {
        File patchFile = File.createTempFile("patchdata-", ".upload");
        try {
            Version from = new Version(fromVersion);
            Version to = new Version(toVersion);
            Channel.ChannelId channelId = Channel.ChannelId.of((String)channel, (String)project);
            Map properties = new HashMap();
            if (props != null) {
                properties = (Map)this.objectMapper.readValue(props, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            patch.transferTo(patchFile);
            log.info("Uploading patch to channel [{}] with properties [{}] ", (Object)channelId, properties);
            Patch uploaded = this.channels.get(channelId).upload(from, to, patchFile, properties);
            this.events.patchUpload(uploaded);
        }
        finally {
            patchFile.delete();
        }
    }

    @RequestMapping(value={"{uuid}/diff"}, method={RequestMethod.GET})
    public Diff diff(@PathVariable String uuid, SecurityContextHolderAwareRequestWrapper request) throws IOException {
        Patch patch = (Patch)this.patchRepository.findOne((Serializable)((Object)uuid));
        if (patch == null) {
            throw new IllegalArgumentException("No patch with given id");
        }
        if (!HasAccess.hasAccessToProject((Project)patch.getChannel().getProject(), (SecurityContextHolderAwareRequestWrapper)request)) {
            throw new AccessDeniedException("Client not permitted to download a patch");
        }
        PatchFormat patchFormat = patch.getChannel().getProject().getPatchFormat();
        if (patchFormat == PatchFormat.PLUSWORKFLOW) {
            PlusWorkflowPatchFormat handler = (PlusWorkflowPatchFormat)patchFormat.handler();
            Index index = handler.readIndex(this.patchStorage.read(patch).getFile());
            return Diff.builder().added((List)Lists.newArrayList((Iterable)index.getAdded())).updated((List)Lists.newArrayList((Iterable)index.getUpdated())).deleted((List)Lists.newArrayList((Iterable)index.getDeleted())).build().sorted();
        }
        return null;
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/{uuid}"}, method={RequestMethod.DELETE})
    public void archive(@PathVariable String uuid) {
        Patch patch = (Patch)this.patchRepository.findOne((Serializable)((Object)uuid));
        if (patch == null) {
            throw new IllegalArgumentException("No patch with given id");
        }
        this.patchRepository.save((Object)patch.archive());
    }
}

