/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.ChannelRepository;
import com.suncode.autoupdate.server.channel.UpdatePlan;
import com.suncode.autoupdate.server.channel.graph.ChannelGraph;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchHandler;
import com.suncode.autoupdate.server.patch.Version;
import com.suncode.autoupdate.server.patch.storage.PatchStorage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.DijkstraShortestPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class UpdateChannel {
    private static final Logger log = LoggerFactory.getLogger(UpdateChannel.class);
    private final Channel channel;
    private final ChannelRepository channelRepository;
    private final PatchStorage storage;
    private final ChannelGraph graph;

    public UpdateChannel(Channel channel, ChannelRepository channelRepository, PatchStorage storage) {
        Assert.notNull((Object)channel);
        Assert.notNull((Object)storage);
        Assert.notNull((Object)channelRepository);
        this.channel = channel;
        this.storage = storage;
        this.channelRepository = channelRepository;
        this.graph = new ChannelGraph(this);
    }

    public Channel.ChannelId id() {
        return this.channel.getId();
    }

    public List<Patch> getPatches() {
        return Collections.unmodifiableList(this.channel.getPatches());
    }

    public ChannelGraph graph() {
        return this.graph;
    }

    public Optional<Patch> newestPatch() {
        return Optional.ofNullable(this.graph.findNewest());
    }

    public UpdatePlan checkUpdates(Version version) {
        Patch newest;
        if (!this.graph.containsVertex((Object)version)) {
            version = Version.ANY;
        }
        if ((newest = this.graph.findNewest(version)) == null) {
            log.info("No newest version for {} in channel {}", (Object)version, (Object)this.channel);
            return UpdatePlan.EMPTY;
        }
        UpdatePlan plan = new UpdatePlan(newest.getToVersion());
        if (newest.getToVersion().equals((Object)version)) {
            log.info("No updates found from {} to {} in channel {}", new Object[]{version, newest.getToVersion(), this.channel});
            return plan;
        }
        log.info("Found newest version {} with ability to update from {} in channel {}", new Object[]{newest.getToVersion(), version, this.channel});
        GraphPath updatePath = this.updatePath(version, newest.getToVersion());
        for (Patch patch : updatePath.getEdgeList()) {
            plan.addPatch(patch);
            if (patch.getChecksum() != null) continue;
            Resource patchArchive = this.storage.read(patch);
            HashingInputStream in = new HashingInputStream(Hashing.md5(), patchArchive.getInputStream());
            Throwable throwable = null;
            try {
                byte[] buffer = new byte[1000000];
                while (IOUtils.read((InputStream)in, (byte[])buffer) == buffer.length) {
                }
                patch.setChecksum(in.hash().toString());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (in == null) continue;
                if (throwable != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                in.close();
            }
        }
        return plan;
    }

    private GraphPath<Version, Patch> updatePath(Version version, Version target) {
        DijkstraShortestPath shortestPath = new DijkstraShortestPath((Graph)this.graph, (Object)version, (Object)target);
        if (shortestPath.getPath() == null) {
            shortestPath = new DijkstraShortestPath((Graph)this.graph, (Object)Version.ANY, (Object)target);
        }
        return shortestPath.getPath();
    }

    public synchronized Patch upload(Version fromVersion, Version toVersion, File patchArchive, Map<String, String> properties) throws IOException {
        Patch patch = this.getPatch(fromVersion, toVersion);
        for (String key : properties.keySet()) {
            patch.addProperty(key, properties.get(key));
        }
        if (this.graph.willCreateCycle(patch)) {
            throw new IllegalStateException("Cycle detected");
        }
        PatchHandler handler = this.channel.getPatchFormat().handler();
        if (handler.transforms(patchArchive)) {
            log.info("Uploading patch {} to channel {} using {}", new Object[]{patch.getId(), this.channel, handler});
            this.storage.store(patch, (PatchStorage.StorageOutput)new /* Unavailable Anonymous Inner Class!! */);
            this.channel.getPatches().add(patch);
            this.channelRepository.save((Object)this.channel);
            return patch;
        }
        throw new IllegalStateException("Upload content not handled by " + handler);
    }

    private Patch getPatch(Version fromVersion, Version toVersion) {
        for (Patch patch : this.channel.getPatches()) {
            if (!patch.getFromVersion().equals((Object)fromVersion) || !patch.getToVersion().equals((Object)toVersion)) continue;
            return patch;
        }
        return new Patch(UUID.randomUUID(), this.channel, fromVersion, toVersion);
    }

    public Channel getChannel() {
        return this.channel;
    }
}

