/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.project.Project;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToMany;
import org.springframework.util.Assert;

@Entity
public class Channel {
    @EmbeddedId
    private ChannelId id;
    @ManyToOne
    @MapsId(value="projectName")
    private Project project;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="channel")
    private List<Patch> patches = new ArrayList();

    Channel() {
    }

    public Channel(String name, Project project) {
        Assert.hasText((String)name);
        Assert.notNull((Object)project);
        this.id = new ChannelId(name, project.getName());
        this.project = project;
    }

    public ChannelId getId() {
        return this.id;
    }

    public Project getProject() {
        return this.project;
    }

    public List<Patch> getPatches() {
        return this.patches;
    }

    public PatchFormat getPatchFormat() {
        return this.project.getPatchFormat();
    }

    public String toString() {
        return this.id.toString();
    }
}

