import React from 'react';
import Table from './../../components/Table.jsx';

export default class ProjectsTable extends React.Component {
    render() {
        return <Table id="projects-table" path="projects" columns={[
            {
                title: 'Nazwa',
                data: 'name'
            }, {
                title: 'Typ',
                data: 'type',
                width: 120,
            }, {
              title: 'Kanały',
                sortable: false,
                className: 'text-center',
                data: 'channels',
                width: 100,
                render: function(data, type, full, meta) {
                    return data.map(function(channel){
                      return '<span class="label label-primary">'+channel+'</span>';
                    }).join("");
                }
            },{
                sortable: false,
                className: 'text-center',
                width: 40,
                render: function(data, type, full, meta) {
                    return "<a href=\"#/projects/" + full.name + "\" class=\"btn btn-default btn-xs txt-color-blue\">\
                      <i class=\"fa fa-edit\"></i>\
                    </a>";
                }
            }
        ]}/>
    }
}
