import React from 'react';
import PatchDetails from './PatchDetails.jsx';

export default class PatchesGraph extends React.Component {

    constructor(props) {
        super(props);
        this.state = {};
    }

    componentDidMount() {
        $.get(`projects/${this.props.channel.project}/channels/${this.props.channel.name}/graph`).then((graph) => {
            this.renderGraph(graph);
        });
    }

    renderGraph(graph) {
        var nodes = new vis.DataSet(graph.nodes.map(node => {
            return $.extend(node, {});
        }));
        var edges = new vis.DataSet(graph.edges.map(edge => {

            let items = Object.keys(edge.patch.properties).map(key => {
                let value = edge.patch.properties[key];
                return `<li>${key}: ${value}</li>`;
            }).join('');

            return $.extend(edge, {title: `<ul class="list-unstyled">${items}</ul>`});
        }));

        var options = {
            height: "500px",
            nodes: {
                shape: 'dot',
                size: 10,
                borderWidth: 2,
                color: "#8df1f1",
                font: {
                    size: 15,
                    color: '#ffffff'
                }
            },
            edges: {
                width: 1,
                color: "#39CCCC",
                arrows: 'to'
            },
            interaction: {
                hover: true
            },
            layout: {
                hierarchical: {
                    direction: "LR"
                }
            }
        };
        this.graph = new vis.Network(this.refs.graph, {
            nodes: nodes,
            edges: edges
        }, options);

        this.graph.on("click", params => {
          console.log(params);
            if (params.edges.length == 1) {
              this.setState({patch: edges.get(params.edges[0]).patch});
            }
        });
    }

    render() {
        return (
            <div className="well" style={{
                backgroundColor: "#222222"
            }}>
                <div ref="graph"></div>
                <PatchDetails channel={this.props.channel} patch={this.state.patch}
                   onClose={() => this.setState({patch: null})}/>
            </div>
        );
    }
}
