import React from 'react';

export default class NewClientForm extends React.Component {
    constructor() {
        super();
        this.handleSubmit = this.handleSubmit.bind(this);
    }

    handleSubmit(e) {
        e.preventDefault();

        var form = new FormData(e.currentTarget);
        var user = {
            id: form.get('id'),
            name: form.get('name')
        };
        $.ajax({
            url: "clients",
            dataType: 'json',
            method: 'POST',
            contentType:'application/json',
            data: JSON.stringify(user),
            success: function(data) {
                this.props.onNewClient(data);
            }.bind(this)
        });
    }

    render() {
        return (
            <div className="well">
                <form className="smart-form" onSubmit={this.handleSubmit}>
                    <fieldset>
                        <section>
                            <label className="label">Identyfikator</label>
                            <label className="input">
                                <input name="id" type="text"/>
                            </label>
                        </section>
                        <section>
                            <label className="label">Nazwa</label>
                            <label className="input">
                                <input name="name" type="text"/>
                            </label>
                        </section>
                    </fieldset>
                    <footer>
                        <button type="submit" className="btn btn-primary">
                            Nowy klient
                        </button>
                    </footer>
                </form>
            </div>
        )
    }
}
