import React from "react";
import { withRouter } from "react-router";

import { Checkbox } from "react-icheck";
import Select2 from "../../components/Select2.jsx";
import CreatableSelect from "react-select/creatable";

import Events from "./Events.jsx";
import ConfigurationWizard from "./ConfigurationWizard.jsx";

class Client extends React.Component {
  constructor(props) {
    super(props);
    this.state = {};
    this.refreshToken = this.refreshToken.bind(this);
    this.updateClient = this.updateClient.bind(this);
    this.deleteClient = this.deleteClient.bind(this);
  }
  componentDidMount() {
    $.get(
      "clients/" + this.props.params.id,
      function(client) {
        this.setState({
          client: client,
          editName: client.name,
          editEnvs: client.environments,
          editCompressPatches: client.compressPatches
        });
      }.bind(this)
    );
  }

  refreshToken() {
    $.ajax({
      url: "clients/" + this.props.params.id + "/token/refresh",
      method: "PUT",
      success: function(newToken) {
        this.state.client.apiToken = newToken;
        this.forceUpdate();
      }.bind(this)
    });
  }

  updateClient() {
    var updatedClient = Object.assign({}, this.state.client, {
      name: this.state.editName,
      environments: this.state.editEnvs,
      compressPatches: this.state.editCompressPatches
    });

    $.ajax({
      url: "clients/" + this.state.client.id,
      method: "PUT",
      dataType: "json",
      contentType: "application/json",
      data: JSON.stringify(updatedClient),
      success: function(result) {
        this.setState({
          client: result,
          editName: result.name,
          editEnvs: result.environments,
          editCompressPatches: result.compressPatches
        });
      }.bind(this)
    });
    return false;
  }

  deleteClient() {
    if (confirm("Klient zostanie usunięty. Jesteś pewny?")) {
      $.ajax({
        url: "clients/" + this.state.client.id,
        method: "DELETE",
        success: function() {
          this.props.router.push("/clients");
        }.bind(this)
      });
    }
  }

  onClientFormSubmit(e) {
    e.preventDefault();
    return false;
  }

  render() {
    return <div>{this.state.client ? this.renderClient() : ""}</div>;
  }

  renderClient() {
    return (
      <div>
        <div className="row">
          <div className="col-xs-12 col-sm-7 col-md-7 col-lg-4">
            <h1 className="page-title txt-color-blueDark">
              {this.state.client.name}
            </h1>
          </div>
        </div>
        <div className="row">
          <div className="col-lg-8">
            {this.renderForm()}
            {this.renderApiToken()}
          </div>
          <div className="col-lg-4">
            <ConfigurationWizard
              client={this.state.client}
            ></ConfigurationWizard>
          </div>
        </div>
        <div className="row">
          <div className="col-md-12">
            <Events client={this.state.client} />
          </div>
        </div>
      </div>
    );
  }

  renderForm() {
    return (
      <form
        onSubmit={this.onClientFormSubmit}
        className="well"
        style={{
          backgroundColor: "white"
        }}
      >
        {this.renderEditForm()}
        <div className="form-actions">
          <div className="row">
            <div className="col-lg-12">
              <button className="btn btn-primary" onClick={this.updateClient}>
                Zapisz
              </button>
              &nbsp;
              <button className="btn btn-danger" onClick={this.deleteClient}>
                Usuń klienta
              </button>
            </div>
          </div>
        </div>
      </form>
    );
  }

  renderEditForm() {
    return (
      <div>
        <fieldset>
          <label>Nazwa</label>
          <div className="form-group">
            <input
              className="form-control"
              type="text"
              value={this.state.editName}
              onChange={event => {
                this.setState({ editName: event.target.value });
              }}
            />
          </div>
          <label>Środowiska klienta</label>
          <div className="form-group">
            <CreatableSelect
              isMulti
              onChange={change => {
                this.setState({
                  editEnvs: (change && change.map(option => option.value)) || []
                });
              }}
              options={$.unique(this.state.client.environments).map(env => {
                return { value: env, label: env };
              })}
              value={$.unique(this.state.editEnvs).map(env => {
                return { value: env, label: env };
              })}
            />
          </div>
        </fieldset>
        <fieldset>
          <legend>Opcje projektu</legend>
          <Checkbox
            checked={this.state.editCompressPatches}
            onChange={(e, checked) => {
              this.setState({
                editCompressPatches: checked
              });
            }}
            checkboxClass="icheckbox_square-green"
            increaseArea="20%"
            label=" Kompresuj patche (kompresuje paczki przed wysłaniem ich do klienta, może pomóc w razie problemach z firewall)"
          />
        </fieldset>
      </div>
    );
  }

  renderApiToken() {
    return (
      <div className="well">
        <h6>API Token</h6>
        <p className="text-muted">
          Unikalny token klienta wykorzystywany do uwierzytelnienia.
        </p>
        <div className="input-group">
          <span className="form-control">{this.state.client.apiToken}</span>
          <div className="input-group-btn">
            <div
              className="btn btn-default btn-primary"
              type="button"
              onClick={this.refreshToken}
            >
              <i className="fa fa-cog"></i>
              Generuj nowy klucz
            </div>
          </div>
        </div>
      </div>
    );
  }
}
export default withRouter(Client);
