/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.store;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.suncode.autoupdate.patch.plugin.PluginPatchProperties;
import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.Channels;
import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.client.api.Plugin;
import com.suncode.autoupdate.server.client.api.ProjectId;
import com.suncode.autoupdate.server.client.api.StoreCriteria;
import com.suncode.autoupdate.server.patch.Patch;
import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.project.Project;
import com.suncode.autoupdate.server.project.ProjectRepository;
import com.suncode.autoupdate.server.security.HasAccess;
import com.suncode.autoupdate.server.store.ProductsStorage;
import com.suncode.autoupdate.server.store.Store;
import com.suncode.autoupdate.server.store.StoreResource;
import com.suncode.autoupdate.server.store.wooapi.Product;
import com.suncode.autoupdate.server.util.Lists;
import com.suncode.plugin.framework.Plugin;
import com.suncode.plugin.framework.Reference;
import com.suncode.plugin.framework.Version;
import com.suncode.plugin.framework.requirements.Capabilities;
import com.suncode.plugin.framework.requirements.Requirement;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/store"})
public class StoreResource {
    private static final Logger log = LoggerFactory.getLogger(StoreResource.class);
    private final Channels channels;
    private final ProjectRepository projectRepository;
    private final ObjectMapper objectMapper;
    private final ProductsStorage productsStorage;
    private final Store store;

    @GetMapping(value={"/products"})
    public Collection<Product> products() {
        return this.productsStorage.getNotMappedProducts();
    }

    @GetMapping(value={"/mappings"})
    public Collection<ProductsStorage.Mapped> store() {
        return this.productsStorage.getMappedProducts();
    }

    @PostMapping(value={"mappings"})
    public void add(@RequestBody AddRequest request) {
        this.productsStorage.addMapping(request.getPlugin(), request.getProductPl(), request.getProductEn());
    }

    @DeleteMapping(value={"mappings/{projectId:.*}"})
    public void delete(ProjectId projectId) {
        this.productsStorage.deleteMapping(projectId);
    }

    @Deprecated
    @RequestMapping(value={"/plugins"}, method={RequestMethod.POST})
    public List<Plugin> list(@RequestBody StoreCriteria criteria, SecurityContextHolderAwareRequestWrapper request) {
        return new CapabilitiesResolver(this, StoreResource.getCapabilities((StoreCriteria.ClientCapabilities)criteria.getClientCapabilities())).query(this.channels(criteria, request));
    }

    @RequestMapping(value={"/plugins/{pluginId:.*}"}, method={RequestMethod.POST})
    public ResponseEntity<Plugin> resolveSingle(@PathVariable String pluginId, @RequestBody StoreCriteria.ClientCapabilities capabilities, SecurityContextHolderAwareRequestWrapper request) {
        log.info("Resolving plugin {} for {}", (Object)pluginId, (Object)capabilities);
        Project project = (Project)this.projectRepository.findOne((Serializable)((Object)pluginId));
        if (project == null) {
            return ResponseEntity.notFound().build();
        }
        if (!HasAccess.hasAccessToProject((Project)project, (SecurityContextHolderAwareRequestWrapper)request)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).build();
        }
        UpdateChannel release = this.channels.get(Channel.ChannelId.of((String)"release", (String)pluginId));
        return ResponseEntity.ok((Object)new CapabilitiesResolver(this, StoreResource.getCapabilities((StoreCriteria.ClientCapabilities)capabilities)).query(release));
    }

    @GetMapping
    public List<com.suncode.autoupdate.server.client.api.Product> listProducts(Locale locale) {
        return this.store.list(locale);
    }

    private Stream<UpdateChannel> channels(StoreCriteria criteria, SecurityContextHolderAwareRequestWrapper request) {
        return this.projectRepository.findByPatchFormat(PatchFormat.PLUGIN).stream().filter(HasAccess.withAccessPredicate((SecurityContextHolderAwareRequestWrapper)request)).flatMap(project -> project.getChannels().stream().filter(channel -> criteria.getChannels().matches(channel.getId().getName())).map(channel -> this.channels.get(channel.getId())));
    }

    private List<Requirement> requirements(Patch patch) {
        return Optional.ofNullable(patch.getProperty(PluginPatchProperties.REQUIREMENTS)).map(arg_0 -> this.read(arg_0)).map(pluginRequirements -> pluginRequirements.stream().map(pluginRequirement -> Requirement.builder().reference(Reference.of((String)pluginRequirement.getId(), (Version)Version.parse((String)pluginRequirement.getVersion()))).build()).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private Set<PluginPatchProperties.PluginRequirement> read(String prop) {
        return (Set)this.objectMapper.readValue(prop, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static Capabilities getCapabilities(StoreCriteria.ClientCapabilities client) {
        return Capabilities.builder().hostCapabilities((Collection)Lists.map((Collection)client.getHost(), (Function)StoreResource.hostCapability())).pluginCapabilities((Collection)Lists.map((Collection)client.getPlugins(), (Function)StoreResource.pluginCapability())).build();
    }

    private static Function<StoreCriteria.ClientCapabilities.Component, Capabilities.PluginCapability> pluginCapability() {
        return component -> new Capabilities.PluginCapability(StoreResource.reference((StoreCriteria.ClientCapabilities.Component)component), Plugin.PluginState.ACTIVE);
    }

    private static Function<StoreCriteria.ClientCapabilities.Component, Capabilities.HostCapability> hostCapability() {
        return component -> new Capabilities.HostCapability(StoreResource.reference((StoreCriteria.ClientCapabilities.Component)component));
    }

    private static Reference reference(StoreCriteria.ClientCapabilities.Component component) {
        return Reference.of((String)component.getId(), (Version)Version.parse((String)component.getVersion()));
    }

    @ConstructorProperties(value={"channels", "projectRepository", "objectMapper", "productsStorage", "store"})
    public StoreResource(Channels channels, ProjectRepository projectRepository, ObjectMapper objectMapper, ProductsStorage productsStorage, Store store) {
        this.channels = channels;
        this.projectRepository = projectRepository;
        this.objectMapper = objectMapper;
        this.productsStorage = productsStorage;
        this.store = store;
    }

    static /* synthetic */ List access$100(StoreResource x0, Patch x1) {
        return x0.requirements(x1);
    }
}

