/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.project;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.suncode.autoupdate.server.client.ClientRepository;
import com.suncode.autoupdate.server.event.EventRepository;
import com.suncode.autoupdate.server.patch.PatchFormat;
import com.suncode.autoupdate.server.project.Project;
import com.suncode.autoupdate.server.project.ProjectRepository;
import com.suncode.autoupdate.server.project.dto.ProjectDto;
import com.suncode.autoupdate.server.security.HasAccess;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.annotation.Secured;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/projects"})
public class ProjectController {
    @Autowired
    private ProjectRepository projectRepo;
    @Autowired
    private ClientRepository clientRepo;
    @Autowired
    private EventRepository eventRepo;

    @RequestMapping(method={RequestMethod.GET})
    public List<ProjectDto> get(SecurityContextHolderAwareRequestWrapper request) {
        return ProjectDto.from((Iterable)Iterables.filter((Iterable)this.projectRepo.findAll(), HasAccess.withAccessPredicate((SecurityContextHolderAwareRequestWrapper)request)::test));
    }

    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.GET})
    public ProjectDto get(@PathVariable String name, SecurityContextHolderAwareRequestWrapper request) {
        Project project = (Project)this.projectRepo.findOne((Serializable)((Object)name));
        HasAccess.checkAccessToProject((Project)project, (SecurityContextHolderAwareRequestWrapper)request);
        return new ProjectDto(project);
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(method={RequestMethod.POST})
    public ProjectDto create(@RequestParam String name, @RequestParam String type) {
        Project project = new Project(name, PatchFormat.valueOf((String)type));
        this.projectRepo.save((Object)project);
        return new ProjectDto(project);
    }

    @Secured(value={"ROLE_ADMIN"})
    @Transactional
    @RequestMapping(value={"/{name:.+}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String name) {
        this.eventRepo.deleteByProject(name);
        this.projectRepo.delete((Serializable)((Object)name));
    }

    @Secured(value={"ROLE_ADMIN"})
    @RequestMapping(value={"/{name:.+}/permittedClients"}, method={RequestMethod.PUT})
    public void updatePermittedClients(@PathVariable String name, @RequestBody(required=false) List<String> clients) {
        Project project = (Project)this.projectRepo.findOne((Serializable)((Object)name));
        ArrayList permittedClients = clients != null ? Lists.newArrayList((Iterable)this.clientRepo.findAll(clients)) : Collections.emptyList();
        project.permitClients((List)permittedClients);
        this.projectRepo.save((Object)project);
    }
}

