/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.event;

import com.suncode.autoupdate.server.event.EventType;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.springframework.util.Assert;

@MappedSuperclass
public abstract class AbstractEvent {
    @Id
    @GeneratedValue
    private Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private EventType type;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date date;

    AbstractEvent() {
    }

    public AbstractEvent(EventType type) {
        Assert.notNull((Object)type);
        this.type = type;
        this.date = new Date();
    }

    public Long getId() {
        return this.id;
    }

    public EventType getType() {
        return this.type;
    }

    public Date getDate() {
        return this.date;
    }
}

