/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.channel;

import com.suncode.autoupdate.server.channel.Channel;
import com.suncode.autoupdate.server.channel.Channels;
import com.suncode.autoupdate.server.channel.UpdateChannel;
import com.suncode.autoupdate.server.channel.UpdatePlan;
import com.suncode.autoupdate.server.channel.dto.UpdatePlanDto;
import com.suncode.autoupdate.server.channel.dto.UpdatesDto;
import com.suncode.autoupdate.server.channel.graph.AvailablePatches;
import com.suncode.autoupdate.server.patch.Version;
import com.suncode.autoupdate.server.security.HasAccess;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestWrapper;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UpdateController {
    @Autowired
    private Channels channels;

    @RequestMapping(value={"/updates/{projectId:.+}/{channelId}/check"}, method={RequestMethod.GET})
    public UpdatePlanDto check(@PathVariable String projectId, @PathVariable String channelId, @RequestParam String version, SecurityContextHolderAwareRequestWrapper request) {
        UpdatePlan plan = UpdatePlan.EMPTY;
        UpdateChannel channel = this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId));
        if (HasAccess.hasAccessToProject((UpdateChannel)channel, (SecurityContextHolderAwareRequestWrapper)request)) {
            plan = channel.checkUpdates(new Version(version));
        }
        return new UpdatePlanDto(plan);
    }

    @RequestMapping(value={"/updates/{projectId:.+}/{channelId}"}, method={RequestMethod.GET})
    public UpdatesDto updates(@PathVariable String projectId, @PathVariable String channelId, @RequestParam String version, SecurityContextHolderAwareRequestWrapper request) {
        UpdateChannel channel = this.channels.get(Channel.ChannelId.of((String)channelId, (String)projectId));
        if (HasAccess.hasAccessToProject((UpdateChannel)channel, (SecurityContextHolderAwareRequestWrapper)request)) {
            return UpdatesDto.of((AvailablePatches)channel.graph().availablePatches(new Version(version)));
        }
        return UpdatesDto.none();
    }
}

