package com.suncode.autoupdate.server.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class GZipUtil
{
    public static boolean isGZipped( InputStream in ) throws IOException
    {
        in.mark( 2 );
        int magic = 0;
        try
        {
            magic = in.read() & 0xff | ( ( in.read() << 8 ) & 0xff00 );
        }
        catch ( IOException e )
        {
            return false;
        }
        finally
        {
            in.reset();
        }
        return magic == GZIPInputStream.GZIP_MAGIC;
    }
}