package com.suncode.autoupdate.server.client.api;

import lombok.SneakyThrows;
import retrofit2.Response;
import retrofit2.Retrofit;

public class TrialRegistration
        extends Api<TrialEndpoint> {
    public TrialRegistration(Retrofit retrofit) {
        super(TrialEndpoint.class, retrofit);
    }

    @SneakyThrows
    public Client registerTrial() {
        Response<Client> trial = endpoint.registerTrial().execute();
        if (!trial.isSuccessful()) {
            throw new RuntimeException("Error registering trial with " + trial.raw().request().url()
                    + " [STATUS_CODE: " + trial.code() + "]" + "::" + trial.errorBody().string());
        }
        return trial.body();
    }
}
