package com.suncode.autoupdate.server.client.api;

import com.suncode.autoupdate.server.client.util.GZipUtil;
import lombok.Getter;
import lombok.SneakyThrows;
import lombok.Value;
import lombok.experimental.Delegate;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Retrofit;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;

import static lombok.AccessLevel.NONE;
import static retrofit2.Response.error;

@Value
public class StorePlugin {
    @Delegate
    @Getter(NONE)
    Plugin plugin;
    @Getter(NONE)
    Retrofit retrofit;

    @SneakyThrows
    public void download(Consumer<InputStream> consumer) {
        download(stream -> {
            consumer.accept(stream);
            return null;
        });
    }

    @SneakyThrows
    public <T> T download(Function<InputStream, T> op) {
        Response response = retrofit.callFactory()
                .newCall(new Request.Builder()
                        .url(HttpUrl.get(getContent()))
                        .get()
                        .build())
                .execute();

        if (response.isSuccessful()) {
            try (InputStream in = getUncompressed(response)) {
                return op.apply(in);
            }
        } else {
            throw new ApiException("Error downloading plugin " + getKey(), error(response.body(), response));
        }
    }

    private InputStream getUncompressed(Response response) throws IOException {
        InputStream inputStream = new BufferedInputStream(response.body().byteStream());
        if (GZipUtil.isGZipped(inputStream)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }
}
