package com.suncode.autoupdate.server.client.api;

import com.google.common.collect.ImmutableSet;
import lombok.Builder;
import lombok.RequiredArgsConstructor;
import lombok.Singular;
import lombok.Value;

import java.util.Set;

@Deprecated
@Value
public class StoreCriteria {
    ChannelsFilter channels;
    ClientCapabilities clientCapabilities;

    @Value
    public static class ChannelsFilter {
        Set<String> channels;

        public boolean matches(String channelName) {
            return channels.isEmpty() || channels.contains(channelName);
        }

        public static ChannelsFilter channels(String... channel) {
            return new ChannelsFilter(ImmutableSet.copyOf(channel));
        }
    }

    @Value
    @Builder
    @RequiredArgsConstructor
    public static class ClientCapabilities {
        @Singular("host") Set<Component> host;
        @Singular Set<Component> plugins;

        @Value
        public static class Component {
            String id;
            String version;
        }
    }
}
