package com.suncode.autoupdate.server.client.api;


import retrofit2.Response;

import java.io.IOException;

import static java.lang.String.format;

public class ApiException extends RuntimeException {

    public ApiException(String message, Response response) {
        super(message, new IOException(format("%s %s %s response body: %s",
                response.raw().request().method(),
                response.raw().request().url(),
                response.code(),
                reason(response))));
    }

    private static String reason(Response response) {
        try {
            return response.errorBody().string();
        } catch (IOException e) {
            return "<Unknown> - reason: " + e.getMessage();
        }
    }
}
