/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client.api;

import com.suncode.autoupdate.server.client.api.ApiException;
import com.suncode.autoupdate.server.client.api.Plugin;
import com.suncode.autoupdate.server.client.util.GZipUtil;
import java.beans.ConstructorProperties;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import retrofit2.Retrofit;

public final class StorePlugin {
    private final Plugin plugin;
    private final Retrofit retrofit;

    public void download(Consumer<InputStream> consumer) {
        this.download((InputStream stream) -> {
            consumer.accept((InputStream)stream);
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T download(Function<InputStream, T> op) {
        Response response = this.retrofit.callFactory().newCall(new Request.Builder().url(HttpUrl.get((URI)this.getContent())).get().build()).execute();
        if (!response.isSuccessful()) throw new ApiException("Error downloading plugin " + this.getKey(), retrofit2.Response.error((ResponseBody)response.body(), (Response)response));
        try (InputStream in = this.getUncompressed(response);){
            InputStream inputStream = op.apply(in);
            return (T)inputStream;
        }
    }

    private InputStream getUncompressed(Response response) throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(response.body().byteStream());
        if (GZipUtil.isGZipped(inputStream)) {
            return new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    @ConstructorProperties(value={"plugin", "retrofit"})
    public StorePlugin(Plugin plugin, Retrofit retrofit) {
        this.plugin = plugin;
        this.retrofit = retrofit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StorePlugin)) {
            return false;
        }
        StorePlugin other = (StorePlugin)o;
        Plugin this$plugin = this.plugin;
        Plugin other$plugin = other.plugin;
        if (this$plugin == null ? other$plugin != null : !((Object)this$plugin).equals(other$plugin)) {
            return false;
        }
        Retrofit this$retrofit = this.retrofit;
        Retrofit other$retrofit = other.retrofit;
        return !(this$retrofit == null ? other$retrofit != null : !this$retrofit.equals(other$retrofit));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Plugin $plugin = this.plugin;
        result = result * 59 + ($plugin == null ? 43 : ((Object)$plugin).hashCode());
        Retrofit $retrofit = this.retrofit;
        result = result * 59 + ($retrofit == null ? 43 : $retrofit.hashCode());
        return result;
    }

    public String toString() {
        return "StorePlugin(plugin=" + this.plugin + ", retrofit=" + this.retrofit + ")";
    }

    public boolean isCompatible() {
        return this.plugin.isCompatible();
    }

    public String getKey() {
        return this.plugin.getKey();
    }

    public String getVersion() {
        return this.plugin.getVersion();
    }

    public String getNewestVersion() {
        return this.plugin.getNewestVersion();
    }

    public URI getContent() {
        return this.plugin.getContent();
    }

    public List<Plugin.Unresolved> getUnresolved() {
        return this.plugin.getUnresolved();
    }

    public Plugin withKey(String key) {
        return this.plugin.withKey(key);
    }

    public Plugin withVersion(String version) {
        return this.plugin.withVersion(version);
    }

    public Plugin withNewestVersion(String newestVersion) {
        return this.plugin.withNewestVersion(newestVersion);
    }

    public Plugin withContent(URI content) {
        return this.plugin.withContent(content);
    }

    public Plugin withUnresolved(List<Plugin.Unresolved> unresolved) {
        return this.plugin.withUnresolved(unresolved);
    }
}

