/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.autoupdate.server.client.api;

import com.suncode.autoupdate.server.client.api.Api;
import com.suncode.autoupdate.server.client.api.ApiException;
import com.suncode.autoupdate.server.client.api.Plugin;
import com.suncode.autoupdate.server.client.api.Product;
import com.suncode.autoupdate.server.client.api.ProjectId;
import com.suncode.autoupdate.server.client.api.StoreCriteria;
import com.suncode.autoupdate.server.client.api.StoreEndpoint;
import com.suncode.autoupdate.server.client.api.StorePlugin;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import retrofit2.Response;
import retrofit2.Retrofit;

public class Store
extends Api<StoreEndpoint> {
    public Store(Retrofit retrofit) {
        super(StoreEndpoint.class, retrofit);
    }

    public List<Product> list() {
        return this.list(Locale.ENGLISH);
    }

    public List<Product> list(Locale locale) {
        Response products = ((StoreEndpoint)this.endpoint).list(locale.toLanguageTag()).execute();
        if (!products.isSuccessful()) {
            throw new ApiException("Error retrieving plugins from store", products);
        }
        return (List)products.body();
    }

    public StorePlugin download(ProjectId projectId, StoreCriteria.ClientCapabilities capabilities) {
        Response plugin = ((StoreEndpoint)this.endpoint).get(projectId, capabilities).execute();
        if (!plugin.isSuccessful()) {
            throw new ApiException("Error retrieving plugin from store: " + projectId, plugin);
        }
        return new StorePlugin((Plugin)plugin.body(), this.retrofit);
    }

    @Deprecated
    public List<StorePlugin> getPlugins(StoreCriteria request) {
        Response plugins = ((StoreEndpoint)this.endpoint).getPlugins(request).execute();
        if (!plugins.isSuccessful()) {
            throw new ApiException("Error retrieving plugins from store", plugins);
        }
        return ((List)plugins.body()).stream().map(plugin -> new StorePlugin((Plugin)plugin, this.retrofit)).collect(Collectors.toList());
    }
}

